% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify_water.R
\name{modify_water}
\alias{modify_water}
\alias{modify_water_df}
\title{Modify slots in a \code{water} class object}
\usage{
modify_water(water, slot, value, units)

modify_water_df(
  df,
  input_water = "defined",
  output_water = "modified",
  slot = "use_col",
  value = "use_col",
  units = "use_col"
)
}
\arguments{
\item{water}{A water class object}

\item{slot}{A vector of slots in the water to modify, eg, "tthm"}

\item{value}{A vector of new values for the modified slots}

\item{units}{A vector of units for each value being entered, typically one of c("mg/L", "ug/L", "M", "cm-1"). For ions any units supported by \link{convert_units}
are allowed. For organic carbon, one of "mg/L", "ug/L". For uv254 one of "cm-1", "m-1". For DBPs, one of "ug/L" or "mg/L".}

\item{df}{a data frame containing a water class column, which has already been computed using \link{define_water_df}}

\item{input_water}{name of the column of water class data to be used as the input for this function. Default is "defined_water".}

\item{output_water}{name of the output column storing updated parameters with the class, water. Default is "modified_water".}
}
\value{
A data frame containing columns of selected parameters from a list of water class objects.

\code{modify_water_df} returns a data frame containing a water class column with updated slot
}
\description{
This function modifies selected slots of a \code{water} class object without impacting the other parameters. For example, you can
manually update "tthm" and the new speciation will not be calculated. This function is designed to make sure all parameters
are stored in the correct units when manually updating a water. Some slots cannot be modified with this function because
they are interconnected with too many others (usually pH dependent, eg, hco3). For those parameters, update \link{define_water}.
}
\examples{
water1 <- define_water(ph = 7, alk = 100, tds = 100, toc = 5) \%>\%
  modify_water(slot = "toc", value = 4, units = "mg/L")

water2 <- define_water(ph = 7, alk = 100, tds = 100, toc = 5, ca = 10) \%>\%
  modify_water(slot = c("ca", "toc"), value = c(20, 10), units = c("mg/L", "mg/L"))


example_df <- water_df \%>\%
  define_water_df() \%>\%
  dplyr::mutate(bromide = 50) \%>\%
  modify_water_df(slot = "br", value = bromide, units = "ug/L")

example_df <- water_df \%>\%
  define_water_df() \%>\%
  modify_water_df(
    slot = c("br", "na"),
    value = c(50, 60),
    units = c("ug/L", "mg/L")
  )

}
