% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_map.R
\name{plot_map}
\alias{plot_map}
\title{Plot interactive map of sampling points (default Leaflet pins)}
\usage{
plot_map(
  df,
  color_by = NULL,
  popup = NULL,
  group_by = NULL,
  legend_title = NULL,
  na_rm = TRUE
)
}
\arguments{
\item{df}{data.frame/tibble with coordinates; must contain \code{lat}/\code{lon}
(or \code{latitude}/\code{longitude}, which will be mapped automatically).}

\item{color_by}{optional column used to build a legend (numeric or factor).
It does not change the marker color.}

\item{popup}{optional column name with popup/tooltip text.}

\item{group_by}{optional column name to create overlay layers (e.g., "year").}

\item{legend_title}{optional legend title (used when \code{color_by} is set).}

\item{na_rm}{logical; if \code{TRUE} (default) remove rows with invalid
coordinates.}
}
\value{
a \code{leaflet} htmlwidget.
}
\description{
Creates an interactive Leaflet map of sampling points using the \strong{default
Leaflet marker} (blue pin). Latitude/longitude are autodetected from
columns \code{lat} and \code{lon}. If these columns are not present, but
\code{latitude} and/or \code{longitude} exist, they are automatically
copied to \code{lat} and \code{lon}. You may group layers with
\code{group_by} (e.g., "year") and show popups with \code{popup}.

If \code{color_by} is provided, a legend is drawn to describe the values,
but \strong{markers are not colorized} (the default \emph{Leaflet} pin has fixed
style).
}
\details{
The function expects coordinates in columns named \code{lat} and \code{lon}.
If those columns are not found, but \code{latitude} and/or \code{longitude}
are present, they are copied to \code{lat} and \code{lon} respectively
before plotting.
}
\examples{
\dontshow{if (requireNamespace("leaflet", quietly = TRUE)) withAutoprint(\{ # examplesIf}
data("wq_demo", package = "tikatuwq")
d2 <- wq_demo |>
  validate_wq() |>
  iqa(na_rm = TRUE)
d2$year <- as.integer(format(d2$data, "\%Y"))

# Marcadores padrao + legenda de IQA
plot_map(d2, color_by = "IQA", group_by = "year", popup = "ponto",
         legend_title = "IQA (0–100)")
\dontshow{\}) # examplesIf}
}
