% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KaplanMeier.R
\name{KaplanMeier}
\alias{KaplanMeier}
\title{Risk and survival probability estimates using the Kaplan-Meier method}
\usage{
KaplanMeier(
  time,
  status,
  t,
  risk.H0 = NULL,
  level = 0.95,
  contr = list(tol = 1e-05, k = 3, Trace = FALSE, method = "both")
)
}
\arguments{
\item{time}{vector of times (possibly censored)}

\item{status}{vector of usual survival status indicators (0 for censored observations, 1 for events)}

\item{t}{the time point of interest (e.g. 1 to compute a 1-year risk or survival probability)}

\item{risk.H0}{risk under the null hypothesis, if one would like to compute the correspondng p-value. Default is NULL, for which no p-value is computed.}

\item{level}{confidence level for the confidence intervals. Default is 0.95.}

\item{contr}{list of control parameters. tol=tolerance for numerical computation, default is 1e-5. method="EL", "Wald" or "both"  indicates wether 95\% CI and p-value should be computed based on Empirical Likelihood (EL) inference , Wald-type inference or both.}
}
\value{
object of class 'KaplanMeier'
}
\description{
Computes the Kaplan-Meier estimator to estimate a risk or, equivalently, a survival probability,
with right-censored data, together with a confidence interval and (possibly) a
p-value (for a one-sample hypothesis test). Computation of confidence intervals
and p-values is based on either Empirical Likelihood (EL) inference
or Wald-type inference. Both are non-parametric approaches, which are asymptotically equivalent.
See Thomas & Grunkemeier (1975) for details about the Empirical Likelihood method. For the Wald-type approach,
the asymptotic normal approximation is used on the cloglog scale. See e.g. equation 4.16 in Beyersmann et al (2011).
}
\examples{
# This example reproduces some results presented in Table 1 of Thomas and Grunkemeier (1975)
ResKM.1.95 <- KaplanMeier(time=Freireich$time[Freireich$group==1],
                          status=Freireich$status[Freireich$group==1],
                          t=10, level=0.95, contr=list(tol=1e-4))
ResKM.1.95

}
\references{
Thomas & Grunkemeier (1975). Confidence interval estimation of survival probabilities for censored data. Journal of the American Statistical Association, 70(352), 865-871.

Beyersmann, Allignol,  & Schumacher (2011). Competing risks and multistate models with R. Springer Science & Business Media.
}
\author{
Paul Blanche
}
