% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_multi_legend.R
\name{draw_multi_legend}
\alias{draw_multi_legend}
\title{Draw multiple legends with automatic positioning}
\usage{
draw_multi_legend(legend_list, position = "right!")
}
\arguments{
\item{legend_list}{A list of legend arguments, where each element is itself a
list of arguments that can be passed on to \link{draw_legend}. Legends will be
drawn vertically (top to bottom) in the order that they are provided. Note
that we currently only support dual legends, i.e. the top-level list has a
maximum length of 2.}

\item{position}{String indicating the base keyword position for the
multi-legend. Currently only \code{"right!"} and \code{"left!"} are supported.}
}
\value{
No return value, called for side effect of drawing multiple legends.
}
\description{
Internal function to draw multiple legends (e.g., bubble + color)
with automatic dimension calculation and positioning. This function handles
the internal gymnastics required to determine the individual legend
dimensions, before drawing them in the optimal order and position.
}
\examples{
\dontrun{
oldmar = par("mar")

# Dual legend example (color + bubble)

l1 = list(
  lgnd_labs = c("Red", "Blue", "Green"),
  legend_args = list(title = "Colors"),
  pch = 16,
  col = c("red", "blue", "green"),
  type = "p"
)

l2 = list(
  lgnd_labs = c("Tiny", "Small", "Medium", "Large", "Huge"),
  legend_args = list(title = "Size"),
  pch = 16,
  col = "black",
  cex = seq(0.5, 2.5, length.out = 5),
  type = "p"
)

# Draw together
draw_multi_legend(list(l1, l2), position = "right!")

par(mar = oldmar)
}

}
\seealso{
\link{draw_legend}
}
\keyword{internal}
