% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/player.R
\name{get_my_currently_playing}
\alias{get_my_currently_playing}
\title{Get the object currently being played on the user’s Spotify account.}
\usage{
get_my_currently_playing(
  market = NULL,
  authorization = get_spotify_authorization_code()
)
}
\arguments{
\item{market}{An ISO 3166-1 alpha-2 country code or the string \code{"from_token"}. Provide this parameter if you want to apply \href{https://developer.spotify.com/documentation/general/guides/track-relinking-guide/}{Track Relinking}}

\item{authorization}{Required. A valid access token from the Spotify Accounts service. See the \href{https://developer.spotify.com/documentation/general/guides/authorization-guide/}{Web API authorization guide} for more details. Defaults to \code{spotifyr::get_spotify_access_token()}. The access token must have been issued on behalf of the current user. \cr
The access token must have the \code{user-read-currently-playing} and/or \code{user-read-playback-state} scope authorized in order to read information.}
}
\value{
Returns a data frame of results containing user profile information. See \url{https://developer.spotify.com/documentation/web-api/reference/users-profile/get-current-users-profile/} for more information.
}
\description{
Get the object currently being played on the user’s Spotify account.
}
