% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tinytiger-package.R
\docType{package}
\name{tinytiger-package}
\alias{tinytiger}
\alias{tinytiger-package}
\title{tinytiger: Lightweight Interface to TIGER/Line Shapefiles}
\description{
Download geographic shapes from the \href{https://www.census.gov/geographies/mapping-files/time-series/geo/tiger-line-file.html}{United States Census Bureau TIGER/Line Shapefiles}.
}
\details{
By default, downloading will print status messages and/or a progress bar.
For silent downloads, set \code{option(tinytiger.curl_quiet = TRUE)}.

Downloads will go to \code{option(tinytiger.cache_dir)} if it is set. If it is not,
and \code{rappdirs} is installed, downloads will be cached between sessions in
\code{rappdirs::user_cache_dir("tinytiger")}.
If it is not installed, or if \code{option(tinytiger.use_cache = FALSE)}, then the
cache will be in a temporary directory that does not persist between
sessions.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/alarm-redist/tinytiger}
  \item \url{https://alarm-redist.org/tinytiger/}
  \item Report bugs at \url{https://github.com/alarm-redist/tinytiger/issues}
}

}
\author{
\strong{Maintainer}: Christopher T. Kenny \email{christopherkenny@fas.harvard.edu} (\href{https://orcid.org/0000-0002-9386-6860}{ORCID})

Authors:
\itemize{
  \item Cory McCartan \email{cmccartan@g.harvard.edu}
}

}
\keyword{internal}
