% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scan_clustering.R
\name{scan_clustering}
\alias{scan_clustering}
\title{Scan Tissue for Local Immune Cell Clustering (K-integral)}
\arguments{
\item{ws}{Window size in microns.}

\item{sample}{Character. Sample name in \code{ldata}.}

\item{phenotype}{One of "T cells", "B cells", or "Both".}

\item{plot}{Logical. Show diagnostic plot?}

\item{creep}{Integer. Grid density factor.}

\item{ldata}{Optional list (defaults to global \code{ldata}).}
}
\value{
List of \code{Lest} objects for significant windows.
}
\description{
Sliding-window Centerel L-Function (CLF) version of the Ripley's K analysis with whole tissue pseudo-plots.
}
\examples{
data(toy_ldata)
\donttest{  # This one may produce plots and take ~10 sec
  models <- scan_clustering(ws = 500, sample = "ToySample",
                            phenotype = "B cells", plot = FALSE, ldata = toy_ldata)
  length(models)
}
}
