% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tmap_save.R
\name{tmap_save}
\alias{tmap_save}
\title{Save tmap}
\usage{
tmap_save(
  tm = NULL,
  filename = NA,
  device = NULL,
  width = NA,
  height = NA,
  units = NA,
  dpi = NA,
  outer.margins = NA,
  asp = NULL,
  scale = NA,
  insets_tm = NULL,
  insets_vp = NULL,
  add.titles = TRUE,
  in.iframe = FALSE,
  selfcontained = !in.iframe,
  verbose = NULL,
  ...
)
}
\arguments{
\item{tm}{tmap object}

\item{filename}{filename including extension, and optionally the path.
The extensions pdf, eps, svg, wmf (Windows only), png, jpg, bmp, tiff, and html are supported.
If the extension is missing, the file will be saved as a static plot in \code{"plot"}
mode and as an interactive map (html) in \code{"view"} mode (see details).
The default format for static plots is png, but this can be changed using
the option \code{"output.format"} in \code{\link[=tmap_options]{tmap_options()}}. If \code{NA} (the default),
the file is saved as "tmap01" in the default format, and the number incremented
if the file already exists.}

\item{device}{graphic device to use. Either a device function
(e.g., \code{\link[grDevices:png]{png}} or \code{\link[grDevices:cairo]{cairo_pdf}})
or a text indicating selected graphic device: "pdf", "eps", "svg", "wmf" (Windows only), "png", "jpg", "bmp", "tiff".
If \code{NULL}, the graphic device is guessed based on the \code{filename} argument.}

\item{height, width}{The dimensions of the plot (not applicable for html files).
Units are set with the argument \code{units}. If one of them is not specified,
this is calculated using the formula asp = width / height, where asp is the
estimated aspect ratio of the map. If both are missing, they are set such
that \code{width * height} is equal to the option \code{"output.size"} in \code{\link[=tmap_options]{tmap_options()}}.
This is by default 49, meaning that is the map is a square (so aspect ratio of 1)
both width and height are set to 7.}

\item{units}{units for width and height (\code{"in"}, \code{"cm"}, or \code{"mm"}).
By default, pixels (\code{"px"}) are used if either width or height is set to a
value greater than 50. Else, the units are inches (\code{"in"}).}

\item{dpi}{dots per inch. Only applicable for raster graphics. By default it
is set to 300, but this can be changed using the option \code{"output.dpi"} in \code{\link[=tmap_options]{tmap_options()}}.}

\item{outer.margins}{overrides the outer.margins argument of \code{\link[=tm_options]{tm_options()}} (unless set to \code{NA})}

\item{asp}{if specified, it overrides the asp argument of \code{\link[=tm_options]{tm_options()}}.
\strong{Tip}: set to \code{0} if map frame should be placed on the edges of the image.}

\item{scale}{overrides the scale argument of \code{\link[=tm_options]{tm_options()}} (unless set to \code{NA})}

\item{insets_tm}{tmap object of an inset map, or a list of tmap objects of
multiple inset maps. The number of tmap objects should be equal to the number
of viewports specified with \code{insets_vp}.}

\item{insets_vp}{\code{\link[grid:viewport]{viewport}} of an inset map, or a list
of \code{\link[grid:viewport]{viewport}}s of multiple inset maps. The number of
viewports should be equal to the number of tmap objects specified with \code{insets_tm}.}

\item{add.titles}{add titles to leaflet object.}

\item{in.iframe}{should an interactive map be saved as an iframe?
If so, two HTML files will be saved; one small parent HTML file with the
iframe container, and one large child HTML file with the actual widget.
See \code{\link[widgetframe:saveWidgetframe]{widgetframe::saveWidgetframe()}} for details. By default \code{FALSE},
which means that one large HTML file is saved (see \link[htmlwidgets:saveWidget]{saveWidget()}).}

\item{selfcontained}{when an interactive map is saved, should the resources
(e.g. JavaScript libraries) be contained in the HTML file? If \code{FALSE}, they
are placed in an adjacent directory (see also \code{\link[htmlwidgets:saveWidget]{htmlwidgets::saveWidget()}}).
Note that the HTML file will often still be large when \code{selfcontained = FALSE},
since the map data (polygons and popups), which are also contained in the HTML file,
usually take more space then the map resources.}

\item{verbose}{Deprecated. It is now controlled by the tmap option \code{show.messages}
(see \code{\link[=tmap_options]{tmap_options()}})}

\item{...}{
  Arguments passed on to \code{\link[htmlwidgets:saveWidget]{htmlwidgets::saveWidget}}, \code{\link[widgetframe:saveWidgetframe]{widgetframe::saveWidgetframe}}
  \describe{
    \item{\code{widget}}{Widget to save}
    \item{\code{file}}{File to save HTML into}
    \item{\code{libdir}}{Directory to copy HTML dependencies into (defaults to
filename_files).}
    \item{\code{background}}{Text string giving the html background color of the widget.
Defaults to white.}
    \item{\code{title}}{Text to use as the title of the generated page.}
    \item{\code{knitrOptions}}{A list of \pkg{knitr} chunk options.}
  }}
}
\value{
the filename, invisibly, if export is successful.
}
\description{
Save tmap to a file. This can be either a static plot (e.g. png) or an interactive map (html).
}
\examples{
\dontrun{
	data(NLD_muni, NLD_prov)
	m <- tm_shape(NLD_muni) +
		     tm_fill(col="population", convert2density=TRUE, 
                 style="kmeans", 
                 title=expression("Population (per " * km^2 * ")")) +
		     tm_borders("black", alpha=.5) + 
		 tm_shape(NLD_prov) +
		     tm_borders("grey25", lwd=2) +
		tm_style("classic") +
		tm_format("NLD", inner.margins = c(.02, .15, .06, .15)) + 
	    tm_scale_bar(position = c("left", "bottom")) +
	    tm_compass(position=c("right", "bottom"))
	
	tmap_save(m, "choropleth.png", height = 7) # height interpreted in inches
	tmap_save(m, "choropleth_icon.png", height = 100, scale = .1) # height interpreted in pixels
	
	data(World)
	m2 <- tm_shape(World) +
		tm_fill("well_being", id="name", title="Well-being") +
		tm_format("World")

	# save image
	tmap_save(m2, "World_map.png", width=1920, height=1080, asp=0)

	# cut left inner margin to make sure Antarctica is snapped to frame
	tmap_save(m2 + tm_layout(inner.margins = c(0, -.1, 0.05, 0.01)), 
        "World_map2.png", width=1920, height=1080, asp=0)
	
	# save interactive plot
	tmap_save(m2, "World_map.html")
}
}
