% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tmaptools-package.R
\docType{package}
\name{tmaptools-package}
\alias{tmaptools}
\alias{tmaptools-package}
\title{Thematic Map Tools}
\description{
This package offers a set of handy tool functions for reading and processing spatial data. The aim of these functions is to supply the workflow to create thematic maps, e.g. read shape files, set map projections, append data, calculate areas and distances, and query OpenStreetMap. The visualization of thematic maps can be done with the tmap package.
}
\details{
This page provides a brief overview of all package functions.
}
\section{Tool functions (shape)}{

\tabular{ll}{
\code{\link{approx_areas}}\tab Approximate area sizes of polygons \cr
\code{\link{approx_distances}}\tab Approximate distances \cr
\code{\link{bb}}\tab Create, extract or modify a bounding box \cr
\code{\link{bb_poly}}\tab Convert bounding box to a polygon \cr
\code{\link{get_asp_ratio}}\tab Get the aspect ratio of a shape object \cr
--------------------------- \tab --------------------------------------------------------------------------------------------------- \cr
}
}

\section{Tool functions (colors)}{

\tabular{ll}{
\code{\link{map_coloring}}\tab Find different colors for adjacent polygons \cr
--------------------------- \tab --------------------------------------------------------------------------------------------------- \cr
}
}

\section{Spatial transformation functions}{

\tabular{ll}{
\code{\link{crop_shape}}\tab Crop shape objects \cr
\code{\link{simplify_shape}}\tab Simplify a shape \cr
--------------------------- \tab --------------------------------------------------------------------------------------------------- \cr
}
}

\section{Input and output functions}{

\tabular{ll}{
\code{\link{geocode_OSM}}\tab Get a location from an address description \cr
\code{\link{read_GPX}}\tab Read a GPX file \cr
\code{\link{read_osm}}\tab Read Open Street Map data \cr
\code{\link{rev_geocode_OSM}}\tab Get an address description from a location \cr
--------------------------- \tab --------------------------------------------------------------------------------------------------- \cr
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/r-tmap/tmaptools}
  \item \url{https://r-tmap.github.io/tmaptools/}
  \item Report bugs at \url{https://github.com/r-tmap/tmaptools/issues}
}

}
\author{
\strong{Maintainer}: Martijn Tennekes \email{mtennekes@gmail.com}

}
\concept{GIS}
\concept{spatial data}
\concept{thematic maps}
