% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{import_onehot}
\alias{import_onehot}
\title{Import One-Hot Data and Create a Co-Occurrence Network Model}
\usage{
import_onehot(data, cols, window = 1L)
}
\arguments{
\item{data}{A \code{data.frame} in wide format.}

\item{cols}{An \code{expression} giving a tidy selection of column names to be
transformed into long format (actions). This can be a vector of column names
(e.g., \code{c(feature1, feature2)}) or a range  specified as \code{feature1:feature6}
(without quotes) to include all columns from 'feature1' to 'feature6'
in the order they appear in the data frame. For more information on
tidy selections, see \code{\link[dplyr:select]{dplyr::select()}}.}

\item{window}{An \code{integer} specifying the size of the window for
sequence grouping. Default is 1 (each row is a separate window). Can
also be a \code{character} string giving a name of the column in \code{data} whose
levels define the windows.}
}
\value{
A \code{tna} object for the co-occurrence model.
}
\description{
Import One-Hot Data and Create a Co-Occurrence Network Model
}
\examples{
d <- data.frame(
  window = gl(100, 5),
  feature1 = rbinom(500, 1, prob = 0.33),
  feature2 = rbinom(500, 1, prob = 0.25),
  feature3 = rbinom(500, 1, prob = 0.50)
)
model <- import_onehot(d, feature1:feature3, window = "window")

}
\seealso{
Other data: 
\code{\link{import_data}()},
\code{\link{prepare_data}()},
\code{\link{print.tna_data}()},
\code{\link{simulate.tna}()}
}
\concept{data}
