% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.group_tna}
\alias{plot.group_tna}
\title{Plot a Grouped Transition Network Analysis Model}
\usage{
\method{plot}{group_tna}(x, title, which, ...)
}
\arguments{
\item{x}{A \code{group_model} object.}

\item{title}{A title for each plot. It can be a single string (the same one
will be used for all plots) or a list (one per group)}

\item{which}{An optional \code{integer} vector of groups to plot. By default, all
groups are plotted.}

\item{...}{
  Arguments passed on to \code{\link[=plot.tna]{plot.tna}}
  \describe{
    \item{\code{labels}}{See \code{\link[qgraph:qgraph]{qgraph::qgraph()}}.}
    \item{\code{colors}}{See \code{\link[qgraph:qgraph]{qgraph::qgraph()}}.}
    \item{\code{pie}}{See \code{\link[qgraph:qgraph]{qgraph::qgraph()}}.}
    \item{\code{cut}}{Edge color and width emphasis cutoff value. The default is
the median of the edge weights. See \code{\link[qgraph:qgraph]{qgraph::qgraph()}} for details.}
    \item{\code{show_pruned}}{A \code{logical} value indicating if pruned edges removed by
\code{\link[=prune]{prune()}} should be shown in the plot.  The default is \code{TRUE}, and the
edges are drawn as dashed with a different color to distinguish them.}
    \item{\code{pruned_edge_color}}{A \code{character} string for the color to use for
pruned edges when \code{show_pruned = TRUE}. The default is \code{"pink"}.}
    \item{\code{edge.color}}{See \code{\link[qgraph:qgraph]{qgraph::qgraph()}}.}
    \item{\code{edge.labels}}{See \code{\link[qgraph:qgraph]{qgraph::qgraph()}}.}
    \item{\code{edge.label.position}}{See \code{\link[qgraph:qgraph]{qgraph::qgraph()}}.}
    \item{\code{layout}}{One of the following:
\itemize{
\item A \code{character} string describing a \code{qgraph} layout (e.g., \code{"circle"})
or the name of a \code{igraph} layout function (e.g., \code{"layout_on_grid"}).
\item A \code{matrix} of node positions to use, with a row for each node and
\code{x} and \code{y} columns for the node positions.
\item A layout function from \code{igraph}.
}}
    \item{\code{layout_args}}{A \code{list} of arguments to pass to the \code{igraph} layout
function when \code{layout} is a function or a character string that specifies
a function name.}
    \item{\code{scale_nodes}}{A \code{character} string giving the name of a centrality
measure to scale the node size by. See \code{\link[=centralities]{centralities()}} for valid names.
If missing (the default), uses default \code{\link[qgraph:qgraph]{qgraph::qgraph()}} scaling.
Overrides \code{vsize} provided via \code{...}.}
    \item{\code{scaling_factor}}{A \code{numeric} value specifying how strongly to scale
the nodes when \code{scale_nodes} is provided. Values
between 0 and 1 will result in smaller differences and values larger
than 1 will result in greater differences. The default is \code{0.5}.}
    \item{\code{mar}}{See \code{\link[qgraph:qgraph]{qgraph::qgraph()}}.}
    \item{\code{theme}}{See \code{\link[qgraph:qgraph]{qgraph::qgraph()}}.}
  }}
}
\value{
\code{NULL} (invisibly).
}
\description{
Plots a transition network of each cluster using \code{qgraph}.
}
\examples{
model <- group_model(engagement_mmm)
plot(model, which = 1)

}
\seealso{
Basic functions
\code{\link{build_model}()},
\code{\link{hist.group_tna}()},
\code{\link{hist.tna}()},
\code{\link{plot.tna}()},
\code{\link{plot_frequencies}()},
\code{\link{plot_frequencies.group_tna}()},
\code{\link{plot_mosaic}()},
\code{\link{plot_mosaic.group_tna}()},
\code{\link{plot_mosaic.tna_data}()},
\code{\link{print.group_tna}()},
\code{\link{print.summary.group_tna}()},
\code{\link{print.summary.tna}()},
\code{\link{print.tna}()},
\code{\link{summary.group_tna}()},
\code{\link{summary.tna}()},
\code{\link{tna-package}}
}
\concept{basic}
