% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid-sparkline.R
\name{grid_sparkline}
\alias{grid_sparkline}
\title{Render HTMLwidgets in Grid}
\usage{
grid_sparkline(grid, column, renderer, height = "40px", styles = NULL)
}
\arguments{
\item{grid}{A grid created with \code{\link[=datagrid]{datagrid()}}.}

\item{column}{Column data are stored and where to render widgets.}

\item{renderer}{A \code{function} that will create an HTMLwidget.}

\item{height}{Height of the row (applies to all table).}

\item{styles}{A \code{list} of CSS parameters to apply to the cells where widgets are rendered.}
}
\value{
A \code{datagrid} htmlwidget.
}
\description{
Create small charts in a column.
}
\examples{

library(toastui)
library(apexcharter)

# Create some fake data
spark <- data.frame(
  month = month.name,
  stringsAsFactors = FALSE
)
# Create a list-columns with data.frames
# from which to create charts
spark$data <- lapply(
  X = seq_len(12),
  FUN = function(x) {
    data.frame(x = 1:10, y = sample(1:30, 10, TRUE))
  }
)

# Create the grid
datagrid(spark) \%>\%
  grid_columns(
    columns = "month", width = 150
  ) \%>\%
  grid_sparkline(
    column = "data",
    renderer = function(data) { # this function will render a chart
      apex(data, aes(x, y), type = "area") \%>\%
        ax_chart(sparkline = list(enabled = TRUE))
    }
  )

# You can also use package highcharter for example
# by using the following renderer:
# renderer = function(data) {
#   hchart(data, type = "area", hcaes(x, y)) \%>\%
#     hc_add_theme(hc_theme_sparkline())
# }
}
