% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topology_functions.R
\name{analyze_topology_factors}
\alias{analyze_topology_factors}
\title{Calculate topology characteristics for different IQR factors}
\usage{
analyze_topology_factors(data, factors = NULL, plot = TRUE)
}
\arguments{
\item{data}{Numeric vector containing the data to analyze}

\item{factors}{Numeric vector of factors to test (default: c(1, 2, 4, 8, 16))}

\item{plot}{Logical, whether to display a plot (default: TRUE)}
}
\value{
A \code{data.frame} with the following columns:
\describe{
\item{factor}{Numeric. The IQR factor used for threshold calculation.}
\item{threshold}{Numeric. The calculated threshold value (IQR/factor).}
\item{base_size}{Integer. Number of sets in the topological base.}
\item{max_set_size}{Integer. Size of the largest set in the base.}
\item{min_set_size}{Integer. Size of the smallest set in the base.}
}
If \code{plot = TRUE}, also generates a line plot showing the relationship
between IQR factors and base sizes as a side effect.
}
\description{
This function analyzes how different IQR (Interquartile Range) factors affect
the topology's characteristics. It helps users determine the optimal factor
for their specific data by showing how the factor choice impacts the base size
and set sizes in the resulting topology.
}
\details{
The function works by:
\enumerate{
\item Calculating different thresholds using IQR/factor
\item Creating a subbase using these thresholds
\item Generating the base from intersections of subbase elements
\item Analyzing the resulting topology's characteristics
}

A larger factor results in a smaller threshold, which typically leads to
a finer topology with more distinct sets but smaller set sizes.
}
\examples{
# Generate sample data
data <- rnorm(100)

# Analyze topology with default factors
results <- analyze_topology_factors(data)
print(results)

# Use custom factors
custom_results <- analyze_topology_factors(data, factors = c(2, 4, 6))
print(custom_results)

}
