% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffuse.R
\name{diffuse}
\alias{diffuse}
\title{Diffuse the weights over indirect links.}
\usage{
diffuse(tally, blend)
}
\arguments{
\item{tally}{a \code{toporanga_tally} object.}

\item{blend}{a numerical factor to limit the effect of diffusion; weight of indirect path is multiplied by the given factor, while direct weights are not changed.
When set to 1, function behaves the same as \code{blend} was not given at all, when given 0, whole diffuse returns \code{tally} unchanged.}
}
\value{
A modified \code{toporanga_tally} object.
}
\description{
Uses the Schulze / widest path approach to re-express indirect domination into direct one.
For instance, if \eqn{A\rightarrow B} and \eqn{B\rightarrow C} both have weight 10, but \eqn{A\rightarrow C} has weight 3, it is gonna be corrected to 10 by this function.
}
