#include <stdint.h>
#include <stdlib.h>
#include <stdbool.h>

struct dag {
  uint32_t n;
  uint32_t *n2e;
  bool *graph;
  bool *visited;
  struct stack *fwd;
  struct stack *bck;
};

struct dag* new_dag(uint32_t n){
  struct dag *ans=(struct dag*)malloc(sizeof(struct dag));
  ans->n=n;
  ans->graph=(bool*)malloc(sizeof(bool)*n*n);
  for(uint32_t e=0;e<n*n;e++) ans->graph[e]=false;
  ans->visited=(bool*)malloc(sizeof(bool)*n);
  ans->n2e=(uint32_t*)malloc(sizeof(uint32_t)*n);
  for(uint32_t e=0;e<n;e++) ans->n2e[e]=e;
  ans->fwd=new_stack(n);
  ans->bck=new_stack(n);
  return(ans);
}

void reset(struct dag *x){
  for(uint32_t e=0;e<x->n;e++)
    x->visited[e]=false;
  x->fwd->n=0;
  x->bck->n=0;
}

void free_dag(struct dag *x){
  free_stack(x->bck);
  free_stack(x->fwd);
  free(x->n2e);
  free(x->visited);
  free(x->graph);
  free(x);
}

bool dfs(struct dag *x,uint32_t v,uint32_t lim,bool fwd){
  uint32_t n=x->n;
  struct stack *r=fwd?x->fwd:x->bck;
  if(r) push_stack(r,v);
  x->visited[v]=true;
  for(uint32_t e=0;e<n;e++){
    if(x->graph[(!fwd)?(n*e+v):(n*v+e)]){
      if(x->n2e[e]==lim){
        return(false);
      }
      if(
        (!x->visited[e]) &&
        (fwd?(x->n2e[e]<lim):(x->n2e[e]>lim)) &&
        !dfs(x,e,lim,fwd)
      ){
        return(false);
      }
    }
  }
  return(true);
}


int cmp_fn(const void *a,const void *b){
  uint32_t aa=*((uint32_t*)a);
  uint32_t bb=*((uint32_t*)b);
  return((aa>bb)-(aa<bb));
} 
void sort(struct stack *s,uint32_t *n2e){
  uint32_t n=s->n;
  uint32_t *x=s->cnt;
  uint32_t *xx=(uint32_t*)malloc(sizeof(uint32_t)*n*2);
  for(uint32_t e=0;e<n;e++){
    xx[2*e+1]=x[e];
    xx[2*e]=n2e[x[e]];
  }
  qsort(xx,n,2*sizeof(uint32_t),cmp_fn);
  for(uint32_t e=0;e<n;e++){
    x[e]=xx[2*e+1];
  }
  free(xx);
}

bool add_edge(struct dag *x,uint32_t f,uint32_t t){
  uint32_t n=x->n;
  uint32_t upper=x->n2e[f];
  uint32_t lower=x->n2e[t];
  if(lower<upper){
    reset(x);
    if(!dfs(x,t,upper,true)){
      return(false);
    }
    if(!dfs(x,f,lower,false)){
      return(false);
    }
    sort(x->bck,x->n2e);
    sort(x->fwd,x->n2e);

    uint32_t nn=x->bck->n+x->fwd->n;
    struct stack *l=new_stack(nn);
    for(uint32_t e=0;e<x->bck->n;e++){
      uint32_t w=x->bck->cnt[e];
      x->bck->cnt[e]=x->n2e[w];
      push_stack(l,w);
    }
    for(uint32_t e=0;e<x->fwd->n;e++){
      uint32_t w=x->fwd->cnt[e];
      x->fwd->cnt[e]=x->n2e[w];
      push_stack(l,w);
    }
    uint32_t
      *be=x->bck->cnt,
      *bee=x->bck->cnt+x->bck->n,
      *fe=x->fwd->cnt,
      *fee=x->fwd->cnt+x->fwd->n;
    for(uint32_t e=0;e<nn;e++){
      uint32_t r;
      if(fe==fee || ((be!=bee) && be[0]<fe[0])){
        r=be[0];
        be++;
      }else{
        r=fe[0];
        fe++;
      }
      x->n2e[l->cnt[e]]=r;
    }
    free_stack(l);
  } //else no problem, edge can be added without hassle
  x->graph[n*f+t]=true;
  return(true);
}
