% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_channel_shuffle}
\alias{torch_channel_shuffle}
\title{Channel_shuffle}
\usage{
torch_channel_shuffle(self, groups)
}
\arguments{
\item{self}{(Tensor) the input tensor}

\item{groups}{(int) number of groups to divide channels in and rearrange.}
}
\description{
Channel_shuffle
}
\section{Divide the channels in a tensor of shape }{
math:\verb{(*, C , H, W)} :

Divide the channels in a tensor of shape \eqn{(*, C , H, W)}
into g groups and rearrange them as \eqn{(*, C \frac g, g, H, W)},
while keeping the original tensor shape.
}

\examples{
if (torch_is_installed()) {

input <- torch_randn(c(1, 4, 2, 2))
print(input)
output <- torch_channel_shuffle(input, 2)
print(output)
}
}
