% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dogs-vs-cats.R
\name{dogs_vs_cats_dataset}
\alias{dogs_vs_cats_dataset}
\title{Dog vs cats dataset}
\usage{
dogs_vs_cats_dataset(
  root,
  split = "train",
  download = FALSE,
  ...,
  transform = NULL,
  target_transform = NULL
)
}
\arguments{
\item{root}{path to the data location}

\item{split}{string. 'train' or 'submission'}

\item{download}{whether to download or not}

\item{...}{Currently unused.}

\item{transform}{function that takes a torch tensor representing an image and return another tensor, transformed.}

\item{target_transform}{function that takes a scalar torch tensor and returns another tensor, transformed.}
}
\value{
A \code{\link[torch:dataset]{torch::dataset()}} ready to be used with dataloaders.
}
\description{
Prepares the dog vs cats dataset available in Kaggle
\href{https://www.kaggle.com/c/dogs-vs-cats}{here}
}
\examples{
if (torch::torch_is_installed() && FALSE) {
dogs_cats <- dogs_vs_cats_dataset("./data", token = "path/to/kaggle.json",
                                  download = TRUE)
length(dogs_cats)
}

}
