% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adahessian.R
\name{optim_adahessian}
\alias{optim_adahessian}
\title{Adahessian optimizer}
\usage{
optim_adahessian(
  params,
  lr = 0.15,
  betas = c(0.9, 0.999),
  eps = 1e-04,
  weight_decay = 0,
  hessian_power = 0.5
)
}
\arguments{
\item{params}{Iterable of parameters to optimize.}

\item{lr}{Learning rate (default: 0.15).}

\item{betas}{Coefficients for computing
running averages of gradient
and is square(default: (0.9, 0.999)).}

\item{eps}{Term added to the denominator to improve
numerical stability (default: 1e-4).}

\item{weight_decay}{L2 penalty (default: 0).}

\item{hessian_power}{Hessian power (default: 1.0).}
}
\value{
An optimizer object implementing the \code{step} and \code{zero_grad} methods.
}
\description{
R implementation of the Adahessian optimizer proposed
by Yao et al.(2020). The original implementation is available at
https://github.com/amirgholami/adahessian.
}
\references{
Yao, Z., Gholami, A., Shen, S., Mustafa, M., Keutzer, K.,
& Mahoney, M. (2021).
ADAHESSIAN: An Adaptive Second Order Optimizer for Machine Learning.
Proceedings of the AAAI Conference on Artificial Intelligence, 35(12),
10665-10673.
https://arxiv.org/abs/2006.00719
}
\author{
Rolf Simoes, \email{rolf.simoes@inpe.br}

Felipe Souza, \email{lipecaso@gmail.com}

Alber Sanchez, \email{alber.ipia@inpe.br}

Gilberto Camara, \email{gilberto.camara@inpe.br}
}
