% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transforms-generics.R
\name{transform_five_crop}
\alias{transform_five_crop}
\title{Crop image into four corners and a central crop}
\usage{
transform_five_crop(img, size)
}
\arguments{
\item{img}{A \code{magick-image}, \code{array} or \code{torch_tensor}.}

\item{size}{(sequence or int): Desired output size. If size is a sequence
like c(h, w), output size will be matched to this. If size is an int,
smaller edge of the image will be matched to this number.
i.e, if height > width, then image will be rescaled to
(size * height / width, size).}
}
\description{
Crop the given image into four corners and the central crop. This transform
returns a tuple of images and there may be a mismatch in the number of
inputs and targets your Dataset returns.
}
\seealso{
Other combining_transforms: 
\code{\link{transform_random_apply}()},
\code{\link{transform_random_choice}()},
\code{\link{transform_random_order}()},
\code{\link{transform_resized_crop}()},
\code{\link{transform_ten_crop}()}
}
\concept{combining_transforms}
