% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doc.R
\name{get_docstring}
\alias{get_docstring}
\title{Get docstring for a Function}
\usage{
get_docstring(content, func, collapse = TRUE, template = DOCSTRING_TEMPLATE)
}
\arguments{
\item{content}{R code as string.}

\item{func}{Name of function to get docstring for.}

\item{collapse}{Whether to collapse all docstring into a single string.}

\item{template}{String to return in case no docstring could be found.}
}
\value{
A character vector of length 1 containing either the docstring or the
empty string (in case no documentation could be detected).
}
\description{
The \href{https://roxygen2.r-lib.org/}{roxygen2} package makes it
possible to write documentation for R functions directly above the
corresponding function. This function can be used to retrieve the full
documentation string (docstring).
}
\examples{
uri <- system.file("testfiles/funcs.R", package = "toscutil")
content <- readLines(uri)
func <- "f2"
get_docstring(content, func)
get_docstring(content, func, collapse = TRUE)
}
\keyword{doc}
