% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trackeR.R, R/zzz_aliases.R
\name{concentration_profile}
\alias{concentration_profile}
\alias{concentrationProfile}
\title{Generic method for concentration profiles}
\usage{
concentration_profile(object, session = NULL, what = NULL, ...)

concentrationProfile(object, session = NULL, what = NULL, ...)
}
\arguments{
\item{object}{An object of class \code{\link{trackeRdata}} or \code{\link{distrProfile}}.}

\item{session}{A numeric vector of the sessions to be used,
defaults to all sessions.}

\item{what}{The variables for which the distribution profiles
should be generated. Defaults to all variables in \code{object}
(\code{what = NULL}).}

\item{...}{Currently not used.}
}
\description{
Generic method for concentration profiles
}
\examples{
\dontrun{
## Compute conecntration profiles from distribution profiles
data('run', package = 'trackeR')
dProfile <- distributionProfile(run, what = 'speed', grid = seq(0, 12.5, by = 0.05))
cProfile <- concentrationProfile(dProfile)
plot(cProfile, smooth = FALSE)
plot(cProfile)

## And now directly from the 'trackeRdata' object, which is a
## considerably faster if all that is needed are the concentration
## profiles
cProfile <- concentrationProfile(runs, what = 'speed',
                                 limits = list(speed = c(0, 12.5)))
plot(cProfile, smooth = FALSE)
ridges(cProfile)
plot(cProfile, smooth = TRUE)
}
}
\seealso{
concentration_profile.distrProfile concentration_profile.trackeRdata
}
