% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/07_files.R
\docType{class}
\name{ImageFileSet-class}
\alias{ImageFileSet-class}
\alias{ImageFileSet}
\title{The ImageFileSet class}
\description{
\code{ImageFileSet} is a subclass of \code{FileSet} that is specialised for
images, by pre-populating the format and auxiliary file specification
(although this can be overridden) and by supporting file mapping using the
\code{FileMap} class. If a file set exists on disk and in a map then the
files take priority.
}
\section{Fields}{

\describe{
\item{\code{defaultMap}}{A list representing a default file map which will be
consulted in the absence of on-disk files or an existing file map to try
to resolve paths.}
}}

\section{Methods}{

\describe{
\item{\code{atPaths(paths)}}{Return a handle object to manipulate files at specific paths}

\item{\code{findFormat(paths, intent = c("read", "write"), preference = NULL,
  all = FALSE)}}{Identify and potentially validate files to find the format used at specific paths}

\item{\code{resolvePaths(paths)}}{Perform any special path handling and resolve final paths}
}}

