% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/car_precision.R
\name{car_precision}
\alias{car_precision}
\title{CAR precision matrix from an adjacency matrix}
\usage{
car_precision(
  A,
  type = c("icar", "proper"),
  rho = 0.99,
  tau = 1,
  symmetrize = FALSE,
  check = TRUE
)
}
\arguments{
\item{A}{Square adjacency/weight matrix (base matrix or a `Matrix` sparse type).
Diagonal entries are ignored (set to 0).}

\item{type}{Either `"icar"` or `"proper"`.}

\item{rho}{Spatial dependence parameter for proper CAR. Ignored for ICAR.}

\item{tau}{Positive scalar precision multiplier.}

\item{symmetrize}{If `TRUE`, replaces `A` by `(A + t(A))/2` before construction.}

\item{check}{If `TRUE`, performs basic validation and warnings.}
}
\value{
A symmetric sparse precision matrix `Q` (class `"dsCMatrix"`).
}
\description{
Constructs the precision matrix for an intrinsic CAR (ICAR) or proper CAR model:
\deqn{Q = \tau (D - \rho A), \quad D = \mathrm{diag}(A \mathbf{1}).}
}
\details{
For ICAR, set `type = "icar"` (internally uses \eqn{\rho=1}).
For proper CAR, set `type = "proper"` and choose `rho` so that \eqn{D - \rho A}
is positive definite (no automatic spectral checks are performed).
}
\examples{
A <- matrix(0, 4, 4)
A[1,2] <- A[2,1] <- 1
A[2,3] <- A[3,2] <- 1
A[3,4] <- A[4,3] <- 1
Q_icar <- car_precision(A, type = "icar", tau = 1)
Q_prop <- car_precision(A, type = "proper", rho = 0.9, tau = 2)

}
