% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/augment.R
\name{plot_traffic_map}
\alias{plot_traffic_map}
\title{Quick map helper for augmented roads}
\usage{
plot_traffic_map(roads_aug, fill = c("predicted_mean", "relative_congestion"))
}
\arguments{
\item{roads_aug}{An `sf` object returned by [augment_roads()].}

\item{fill}{Character scalar. Which column of `roads_aug` to map.
One of `"predicted_mean"` or `"relative_congestion"`.}
}
\value{
An invisible copy of `roads_aug`, returned as an `sf` object with the
  augmented columns. The function is called for its plotting side effect.
}
\description{
Plots road geometries colored by an augmented numeric column (e.g.,
posterior mean predictions or relative congestion).
}
