% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hash.R
\name{hash}
\alias{hash}
\title{Hashing}
\usage{
hash(lang = "", text = "", algorithm = "")
}
\arguments{
\item{lang}{A non-empty and non-NA character string. The underlying language.

A language is usually a code (of two or three letters) for a native
language name. While users retain full control over codes, it is best
to use language codes stemming from well-known schemes such as
\href{https://en.wikipedia.org/wiki/IETF_language_tag}{IETF BCP 47}, or
\href{https://en.wikipedia.org/wiki/List_of_ISO_639_language_codes}{ISO 639-1}
to maximize portability and cross-compatibility.}

\item{text}{A non-NA character string. It can be empty.}

\item{algorithm}{A non-empty and non-NA character string equal to \code{"sha1"},
or \code{"utf8"}. The algorithm to use when hashing source information for
identification purposes.}
}
\value{
\code{\link[=hash]{hash()}} returns a character string, or \code{NULL} if \code{algorithm} is not
supported.
}
\description{
Map an arbitrary character string to a shorter string of hexadecimal
characters highly likely to be unique. It typically has a fixed width.

\strong{Arguments listed below are not validated for efficiency.}
}
\details{
Hashes generated by \code{\link[=hash]{hash()}} uniquely identify the \code{lang} and \code{text} pair.
Values passed to these arguments are concatenated with a colon character for
hashing purposes.
}
\seealso{
\code{\link{Translator}},
\code{\link{Text}},
\code{\link[=normalize]{normalize()}},
\code{\link[=algorithms]{algorithms()}}
}
\keyword{internal}
