% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node.R
\name{node-field-name-for-child}
\alias{node-field-name-for-child}
\alias{node_field_name_for_child}
\alias{node_field_name_for_named_child}
\title{Get a child's field name by index}
\usage{
node_field_name_for_child(x, i)

node_field_name_for_named_child(x, i)
}
\arguments{
\item{x}{\verb{[tree_sitter_node]}

A node.}

\item{i}{\verb{[integer(1)]}

The index of the child to get the field name for.}
}
\value{
The field name for the \code{i}th child of \code{x}, or \code{NA_character_} if that child
doesn't exist.
}
\description{
These functions return the field name for the \code{i}th child of \code{x}.
\itemize{
\item \code{node_field_name_for_child()} considers both named and anonymous children.
\item \code{node_field_name_for_named_child()} considers only named children.
}

Nodes themselves don't know their own field names, because they don't know
if they are fields or not. You must have access to their parents to query
their field names.
}
\examples{
\dontshow{if (rlang::is_installed("treesitter.r")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
language <- treesitter.r::language()
parser <- parser(language)

text <- "fn <- function() { 1 + 1 }"
tree <- parser_parse(parser, text)
node <- tree_root_node(tree)

# Navigate to first child
node <- node_child(node, 1)
node

# Get the field name of the first few children (note that anonymous children
# are considered)
node_field_name_for_child(node, 1)
node_field_name_for_child(node, 2)

# Get the field name of the first few named children (note that anonymous
# children are not considered)
node_field_name_for_named_child(node, 1)
node_field_name_for_named_child(node, 2)

# 10th child doesn't exist, this returns `NA_character_`
node_field_name_for_child(node, 10)
\dontshow{\}) # examplesIf}
}
