% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/json_writers.R
\name{write_display_obj}
\alias{write_display_obj}
\title{Write a "display object" file for a Trelliscope app}
\usage{
write_display_obj(
  cogdf,
  panel_example,
  base_path,
  id,
  name,
  group = "common",
  desc = "",
  height = 500,
  width = 500,
  inputs = NULL,
  md_desc = "",
  state = NULL,
  google_analytics_id = NULL,
  views = NULL,
  jsonp = TRUE,
  split_sig = NULL,
  panel_img_col = NULL,
  self_contained = FALSE,
  thumb = TRUE,
  split_layout = FALSE,
  split_aspect = NULL,
  has_legend = FALSE,
  order = 1,
  pb = NULL
)
}
\arguments{
\item{cogdf}{a data frame of cognostics, prepared with \code{\link{as_cognostics}}}

\item{panel_example}{an example object of one panel of a display (can be trellis, ggplot2, or htmlwidget object)}

\item{base_path}{the base directory of the trelliscope application}

\item{id}{a unique id for the application}

\item{name}{name of the display}

\item{group}{group that the display belongs to}

\item{desc}{description of the display}

\item{height}{height in pixels of each panel}

\item{width}{width in pixels of each panel}

\item{inputs}{optional set of input specifications (using \code{\link{input_cogs}}) to allow user input for each panel}

\item{md_desc}{optional string of markdown that will be shown in the viewer for additional context about the display}

\item{state}{the initial state the display will open in}

\item{google_analytics_id}{optional string specifying Google Analytics ID}

\item{views}{an optional list of pre-specified views of the display (experimental)}

\item{jsonp}{should json for display object be jsonp (TRUE) or json (FALSE)?}

\item{split_sig}{optional string "signature" specifying the data splitting}

\item{panel_img_col}{which column (if any) is a panel image column?}

\item{self_contained}{should the Trelliscope display be a self-contained html document?}

\item{thumb}{should a thumbnail be created?}

\item{split_layout}{boolean that determines if the layout is split into components like a facet_grid vs. individual panels like facet_wrap.  Only applies to ggplot2 plot objects.}

\item{split_aspect}{list indicating aspect ratios of axes for a split layout.  Only applies to ggplot2 plot objects.}

\item{has_legend}{should a legend be reported for split_layout}

\item{order}{an integer indicating the order that the display should appear in if using multiple displays}

\item{pb}{optional progress bar object to pass in and use to report progress}
}
\description{
Write a "display object" file for a Trelliscope app
}
