% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_rsq.R
\name{calculate_rsq}
\alias{calculate_rsq}
\alias{calculate_rsq.default}
\alias{calculate_rsq.trending_model}
\alias{calculate_rsq.list}
\alias{calculate_rsq.trending_fit}
\alias{calculate_rsq.trending_fit_tbl}
\alias{calculate_rsq.trending_predict}
\alias{calculate_rsq.trending_predict_tbl}
\alias{calculate_rsq.trending_prediction}
\title{Generic for calculating the root mean squared error}
\usage{
calculate_rsq(x, ...)

\method{calculate_rsq}{default}(x, ...)

\method{calculate_rsq}{trending_model}(x, data, na.rm = TRUE, as_tibble = TRUE, ...)

\method{calculate_rsq}{list}(x, data, na.rm = TRUE, ...)

\method{calculate_rsq}{trending_fit}(x, new_data, na.rm = TRUE, as_tibble = TRUE, ...)

\method{calculate_rsq}{trending_fit_tbl}(x, new_data, na.rm = TRUE, ...)

\method{calculate_rsq}{trending_predict}(x, na.rm = TRUE, as_tibble = TRUE, ...)

\method{calculate_rsq}{trending_predict_tbl}(x, na.rm = TRUE, ...)

\method{calculate_rsq}{trending_prediction}(x, na.rm = TRUE, as_tibble = TRUE, ...)
}
\arguments{
\item{x}{An \R object.}

\item{...}{Not currently used.}

\item{data}{a \code{data.frame} containing data (including the response variable
and all predictors) used in the specified model.}

\item{na.rm}{Should NA values should be removed before calculation of metric
(passed to the underlying function \link[yardstick:rsq]{yardstick::rsq_vec}).}

\item{as_tibble}{Should the result be returned as \link[tibble:tibble]{tibble}
(\code{as_tibble = TRUE}) or a list (\code{as_tibble = FALSE}).}

\item{new_data}{a \code{data.frame} containing data (including the response variable
and all predictors) on which to assess the model.}
}
\value{
For a single \code{\link[trending:fit]{trending_fit}} input, if
\code{as_tibble = FALSE} the object returned will be a list with entries:
\itemize{
\item metric: "rsq"
\item result: the resulting rsq value (NULL if the calculation failed)
\item warnings: any warnings generated during calculation
\item errors: any errors generated during calculation
}

If \code{as_tibble = TRUE}, or for the other \code{trending} classes, then the output
will be a \link[tibble:tibble]{tibble} with one row for each fitted model
columns corresponding to output generated with single model input.
}
\description{
Generic \code{calculate_rsq()} returns the root mean square error for the given
input.
}
\details{
Specific methods are given for
\code{\link[trending:trending_model]{trending_model}}
(and lists of these), \code{\link[trending:fit.trending_model]{trending_fit}},
\code{\link[trending:fit.trending_model]{trending_fit_tbl}},
\code{\link[trending:predict.trending_fit]{trending_predict_tbl}},
\code{\link[trending:predict.trending_fit_tbl]{trending_predict_tbl}} and
\code{trending_prediction} objects. Each of these are simply wrappers around the
\link[yardstick:rsq]{yardstick::rsq_vec} with the addition of explicit error handling.
}
\author{
Tim Taylor

#' @examples
x = rnorm(100, mean = 0)
y = rpois(n = 100, lambda = exp(1.5 + 0.5*x))
dat <- data.frame(x = x, y = y)
poisson_model <- glm_model(y ~ x , family = "poisson")
negbin_model <- glm_nb_model(y ~ x)
fitted_model <- fit(poisson_model, dat)
fitted_models <- fit(list(poisson_model, negbin_model), data = dat)

calculate_rsq(poisson_model, dat)
calculate_rsq(fitted_model)
calculate_rsq(fitted_model, as_tibble = TRUE)
calculate_rsq(fitted_models)
}
