% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict-list.R
\name{predict.list}
\alias{predict.list}
\title{Predict method for trending_model objects}
\usage{
\method{predict}{list}(
  object,
  data,
  name = "estimate",
  alpha = 0.05,
  add_ci = TRUE,
  ci_names = c("lower_ci", "upper_ci"),
  add_pi = TRUE,
  pi_names = c("lower_pi", "upper_pi"),
  simulate_pi = FALSE,
  sims = 2000,
  uncertain = TRUE,
  ...
)
}
\arguments{
\item{object}{A list of \code{\link{trending_model}} objects.}

\item{data}{A \code{data.frame} containing data to which the model is to be fit
and estimates derived.}

\item{name}{Character vector of length one giving the name to use for the
calculated estimate.}

\item{alpha}{The alpha threshold to be used for prediction intervals,
defaulting to 0.05, i.e. 95\% prediction intervals are derived.}

\item{add_ci}{Should a confidence interval be added to the output.
Default TRUE.}

\item{ci_names}{Names to use for the resulting confidence intervals.}

\item{add_pi}{Should a prediction interval be added to the output.
Default TRUE.}

\item{pi_names}{Names to use for the resulting prediction intervals.}

\item{simulate_pi}{Should the prediction intervals for glm models be
simulated. If TRUE, default, \code{predict()} uses the \code{\link[ciTools:add_pi]{ciTools::add_pi()}}
function to generate the intervals.}

\item{sims}{The number of simulations to run when simulating prediction
intervals for a glm model.}

\item{uncertain}{Only used for glm models and when \code{simulate_pi = FALSE}.
Default TRUE.  If FALSE uncertainty in the fitted parameters is ignored
when generating the parametric prediction intervals.}

\item{...}{Not currently used.}
}
\value{
A \code{trending_predict_tbl} object which is a
\code{\link[tibble:tibble]{tibble}} subclass with one row per model and columns:
\itemize{
\item result: the input data frame with additional estimates and, optionally,
confidence and or prediction intervals. \code{NULL} if the associated
\code{predict} method fails.
\item warnings: any warnings generated during prediction.
\item errors: any errors generated during prediction.
}
}
\description{
Adds estimated values and associated confidence and/or prediction intervals
to data based on trending_model fit.
}
\examples{
x = rnorm(100, mean = 0)
y = rpois(n = 100, lambda = exp(1.5 + 0.5*x))
dat <- data.frame(x = x, y = y)
poisson_model <- glm_model(y ~ x , family = "poisson")
negbin_model <- glm_nb_model(y ~ x)
predict(list(poisson_model, negbin_model), dat)
predict(list(pm = poisson_model, nm = negbin_model), dat)

}
\seealso{
\code{\link[=predict.trending_model]{predict.trending_model()}}, \code{\link[=predict.trending_fit]{predict.trending_fit()}},
\code{\link[=predict.trending_fit_tbl]{predict.trending_fit_tbl()}},
}
\author{
Tim Taylor
}
