% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_weekly_cases.R
\encoding{UTF-8}
\name{plot_weekly_cases}
\alias{plot_weekly_cases}
\title{Visualize Weekly Aggregated Values / Woechentliche aggregierte Werte visualisieren}
\usage{
plot_weekly_cases(
  df,
  datum_col = "datum",
  value_col = NULL,
  weeks_back = 51,
  agg_fun = "sum",
  plottype = NULL,
  save_plot = FALSE,
  save_path = "."
)
}
\arguments{
\item{df}{A data.frame with date and value columns. / Ein Data Frame mit Datums- und Wertespalten}

\item{datum_col}{Name of the date column, default is "datum". / Name der Datumsspalte, Standard: "datum"}

\item{value_col}{Name of the value column. / Name der Wertespalte /}

\item{weeks_back}{Number of recent weeks or a length-2 numeric vector. / Anzahl der zurueckliegenden Wochen oder ein Vektor mit zwei Werten}

\item{agg_fun}{Aggregation function (e.g., "sum", "mean"). / Aggregationsfunktion, z.B. "sum", "mean"}

\item{plottype}{Optional plot type: 1 for all, 2 for hist+box, 3 for trend+box. / Optionaler Plottyp: 1 fuer alle, 2 fuer hist+box, 3 fuer trend+box}

\item{save_plot}{Logical, whether to save the plots. / Logisch, ob die Plots gespeichert werden sollen}

\item{save_path}{Folder to save the plots. / Zielpfad zum Speichern der Plots}
}
\value{
A list containing:
\describe{
  \item{data}{Aggregated weekly data}
  \item{trend_plot}{Trend plot}
  \item{hist_plot}{Histogram}
  \item{box_plot}{Boxplot}
}
}
\description{
This function aggregates time series data by calendar week and generates three plots trend line, histogram, and boxplot based on a specified retrospective period (either a number of weeks or a date range). It also shows a 95% confidence interval and can optionally save the plots.
}
\details{
Diese Funktion aggregiert Zeitreihendaten nach Kalenderwochen und erstellt fuer den angegebenen Rueckblickzeitraum (als Anzahl der Wochen oder Zeitfenster) drei Diagramme: Trendverlauf, Histogramm und Boxplot. Zusaetzlich wird ein 95%-Konfidenzintervall angezeigt. Optional koennen die Plots gespeichert werden.
}
\examples{
df <- data.frame(
  datum = as.Date("2022-01-01") + 0:100,
  neue_faelle = rpois(101, lambda = 20)
)
result <- plot_weekly_cases(df, value_col = "neue_faelle", weeks_back = 20)
}
