% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_alpha.R
\name{add_alpha}
\alias{add_alpha}
\title{Calculate and add \eqn{\alpha}}
\usage{
add_alpha(data, abs = FALSE)
}
\arguments{
\item{data}{\code{data.frame} of stable isotope samples with mean values for two
baselines. For aquatic ecosystems, baseline one needs to come from a
benthic source and baseline two needs to come
from a pelagic source. Baseline \eqn{\delta^{13}}C columns
need to be named \code{c1} and \code{c2},
with the consumer's \eqn{\delta^{13}}C column named \code{d13c}.}

\item{abs}{logical that controls whether the absolute value is taken for the
numerator and denominator. Default is \code{FALSE} meaning that the absolute
value is not taken.}
}
\value{
a \code{data.frame} that has \code{alpha}, \code{min_alpha}, and \code{max_alpha} added.
}
\description{
Calculate \eqn{\alpha} for a two source trophic position model using
equations from \href{https://esajournals.onlinelibrary.wiley.com/doi/full/10.1890/0012-9658\%282002\%29083\%5B0703\%3AUSITET\%5D2.0.CO\%3B2}{Post 2002}.
}
\details{
\deqn{\alpha = (\delta^{13}C_c - \delta ^{13}C_2) /
(\delta ^{13}C_1 - \delta ^{13}C_2)}

where \eqn{\delta^{13}C_c} is the isotopic value for consumer,
\eqn{\delta^{13}C_1} is the mean isotopic value for baseline 1 and
\eqn{\delta^{13}C_2} is the mean isotopic value for baseline 2.
}
\examples{
combined_iso |>
  add_alpha()
}
