% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trud_items.R
\name{trud_items}
\alias{trud_items}
\title{Get available NHS TRUD items}
\usage{
trud_items()
}
\value{
A tibble, with columns \code{item_number} and \code{item_name}. Use the
\code{item_number} values as arguments to \code{\link[=get_item_metadata]{get_item_metadata()}} and \code{\link[=download_item]{download_item()}}.
}
\description{
Scrapes \href{https://isd.digital.nhs.uk/trud/users/guest/filters/0/categories/1}{this page}
from the NHS TRUD website for all available items. The \code{item_number} column
in the result contains the identifiers you need for \code{\link[=get_item_metadata]{get_item_metadata()}}
and \code{\link[=download_item]{download_item()}}.

\emph{\strong{Subscription Required}}

You must subscribe to TRUD items individually through the NHS TRUD website
before you can access them using \code{\link[=get_item_metadata]{get_item_metadata()}} or \code{\link[=download_item]{download_item()}}.
Simply having an API key is not sufficient. To see items you're already
subscribed to, use \code{\link[=get_subscribed_metadata]{get_subscribed_metadata()}}. To browse all available
items, use \code{\link[=trud_items]{trud_items()}}.
}
\examples{
\dontshow{if (identical(Sys.getenv("IN_PKGDOWN"), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
trud_items()
\dontshow{\}) # examplesIf}
}
\seealso{
\itemize{
\item \code{\link[=get_subscribed_metadata]{get_subscribed_metadata()}} to see only items you're subscribed to
\item \code{\link[=get_item_metadata]{get_item_metadata()}} to get detailed information about a specific item
\item \code{\link[=download_item]{download_item()}} to download files for a specific item
}
}
