% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{power_calc}
\alias{power_calc}
\title{Calculate power to detect non-zero lying}
\usage{
power_calc(N, P, lambda, alpha = 0.05, prior = stats::dunif,
  nsims = 200)
}
\arguments{
\item{N}{Total number in sample}

\item{P}{Probability of \emph{bad} outcome}

\item{lambda}{Probability of a subject lying}

\item{alpha}{Significance level to use for the null hypothesis}

\item{prior}{Prior over lambda. A function which takes a vector of values
between 0 and 1, and returns the probability density. The default is
the uniform distribution.}

\item{nsims}{Number of simulations to run}
}
\value{
Estimated power, a scalar between 0 and 1.
}
\description{
This uses simulations to estimate the power to detect a given level of lying in a
sample of size \code{N} by this package's methods.
}
\examples{

power_calc(N = 50, P = 0.5, lambda = 0.2)

}
