% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lib.R
\name{nearest}
\alias{nearest}
\title{Nearest neighbor computation for the TRUH statistic}
\usage{
nearest(y, U, n, d)
}
\arguments{
\item{y}{a \eqn{d} dimensional vector.}

\item{U}{a \eqn{n\times d} matrix where \eqn{n} represents the sample size and
\eqn{d} is the dimension of each sample.}

\item{n}{the sample size.}

\item{d}{dimension of each sample.}
}
\value{
\enumerate{
\item d1 - nearest neighbor of \eqn{\mathbf{y}} in \eqn{\mathbf{U}}
\item d2 - nearest neighbor of d1 in \eqn{\mathbf{U}}
}
}
\description{
For a given \eqn{d} dimensional vector \eqn{\mathbf{y}}, this function finds the nearest neighbor of \eqn{\mathbf{y}} in
a \eqn{n\times d} matrix \eqn{\mathbf{U}}.
}
\examples{
library(truh)
n = 100
d = 3
set.seed(1)
y = rnorm(3)
set.seed(2)
U = matrix(rnorm(n*d),nrow=n,ncol=d)
out = nearest(y,U,n,d)

}
\seealso{
\code{\link{truh}}
}
