% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/est_FG.R
\name{G_est}
\alias{G_est}
\title{Estimate the Conditional CDF for the Left Truncation Time given Covariates}
\usage{
G_est(
  dat.fit,
  dat.est = dat.fit,
  time.eval,
  model,
  time.name,
  Q.name,
  event.name,
  cov.names,
  trim = 0,
  weights = rep(1, nrow(dat.fit)),
  formula.survPen = NA
)
}
\arguments{
\item{dat.fit}{data frame that is used to fit the model for the full data conditional distribution of the event time given the covariates.}

\item{dat.est}{data frame that contains the subjects for which the estimated conditional CDF is computed.}

\item{time.eval}{vector of time points at which the conditional CDF is evaluated.}

\item{model}{method used to estimate the conditional CDF. The options available are "Cox" and "spline", corresponding to Cox proportional hazards regression using function \code{coxph()} from  R package `survival', and the hazard model with penalized splines using function \code{survPen()} from R package `survPen', respectively.}

\item{time.name}{name of the event time variable.}

\item{Q.name}{name of the left truncation time variable.}

\item{event.name}{name of the event indicator.}

\item{cov.names}{vector of the names of covariates.}

\item{trim}{constant for bounding the estimated conditional CDF from 0.}

\item{weights}{vector of case weights.}

\item{formula.survPen}{the formula when applying the hazard model with penalized splines implemented in \code{survPen::survPen}.}
}
\value{
\code{G_est()} returns a matrix of the estimated conditional CDF for subjects in `\code{data.est}' evaluated at the time points in the vector `\code{time.eval}'. Each row corresponds to a subject and each column corresponds to a time point. The column names of the matrix are the times in `\code{time.eval}'.
}
\description{
Estimate the conditional cumulative distribution function (CDF) of the left truncation time given covariates evaluated at given time points. The options implemented in this function are: Cox proportional hazards regression using function \code{coxph()} from  R package `survival', and the hazard model with penalized splines using function \code{survPen()} from R package `survPen'.
}
\examples{
data("simu")
v = c(0.5, 1, 1.5, 2, 2.5, 3)
Gvz.mx = G_est(simu, simu[1:10,], v, "Cox", "time", "Q", "delta", c("Z1","Z2"))
}
\seealso{
\code{\link{F_est}}
}
