% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utrunmnt.R
\name{utrunmnt}
\alias{utrunmnt}
\title{Compute the \eqn{k}-th order moment for an univariate truncated normal 
distribution.}
\usage{
utrunmnt(k, mu = 0, lower = -Inf, upper = Inf, sd = 1)
}
\arguments{
\item{k}{Order of moment. It must be a non-negative integer.}

\item{mu}{Mean of parent normal distribution. Defaults to 0.}

\item{lower}{Lower limit. Defaults to -Inf.}

\item{upper}{Upper limit. Defaults to Inf.}

\item{sd}{Standard deviation of parent normal distribution. Defaults to 1.}
}
\value{
a numeric value.
}
\description{
The \code{utrunmnt} function uses the moment generating function to compute 
  any order of moment for the truncated normal distribution.
}
\examples{
utrunmnt(4, mu = 5, upper = 10)
utrunmnt(1, mu = 5, lower = -3, upper = 4, sd = 2)

}
\references{
Burkardt, J. (2014). The truncated normal distribution, \emph{Online document}, Available from: 
\url{https://people.sc.fsu.edu/~jburkardt/presentations/truncated_normal.pdf}.
}
