% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frequdom.r
\name{periodogram}
\alias{periodogram}
\title{\code{periodogram} determines the periodogram of a time series}
\usage{
periodogram(y, nf, ACF = FALSE, type = "cov")
}
\arguments{
\item{y}{(n,1) vector, the time series or  an  acf at lags 0,1,...,n-1}

\item{nf}{scalar, the number of equally spaced frequencies; not necessay an integer}

\item{ACF}{logical, FALSE, if y is ts, TRUE, if y is acf}

\item{type}{c("cov","cor"), area under spectrum, can be variance or normed to 1.}
}
\value{
out  (floor(nf/2)+1,2) matrix, the frequencies and the periodogram
}
\description{
\code{periodogram} determines the periodogram of a time series
}
\examples{
data(WHORMONE)
## periodogram at Fourier frequencies and frequencies 0 and 0.5 
out <-periodogram(WHORMONE,length(WHORMONE)/2,ACF=FALSE,type="cov") 
}
