% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/profile.R
\name{tsprofile.tsgarch.spec}
\alias{tsprofile.tsgarch.spec}
\alias{tsprofile}
\title{Model Parameter Profiling}
\usage{
\method{tsprofile}{tsgarch.spec}(
  object,
  nsim = 100,
  sizes = c(800, 1000, 1500, 2000, 3000),
  var_init = NULL,
  seed = NULL,
  burn = 0,
  trace = FALSE,
  ...
)
}
\arguments{
\item{object}{an object of class \dQuote{tsgarch.spec} with pre-set parameters.}

\item{nsim}{the number of paths to generate.}

\item{sizes}{a vector of data sizes for which to simulate and estimate.}

\item{var_init}{the variance to use to initialize the simulation.}

\item{seed}{an object specifying if and how the random number generator
should be initialized. See the simulate documentation for more details.}

\item{burn}{burn in samples.}

\item{trace}{whether to show the progress bar. The user is expected to have
set up appropriate handlers for this using the \dQuote{progressr} package.}

\item{...}{not currently used.}
}
\value{
An object of class \dQuote{tsgarch.profile}.
}
\description{
Profiles the model parameters under the assumptions of the model.
}
\details{
The function profiles the parameters of a model by simulating and
then estimating multiple paths from the assumed DGP. This makes it possible
to obtain a better understanding of the convergence properties (RMSE) of each
parameter under different data sizes.
}
\note{
The function can use parallel functionality as long as the user has set
up a \code{\link[future]{plan}} using the future package.
External regressors are not supported at this time and an error will occur
if persent in the specification.
}
