% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSModelDynamicGompertz.R
\docType{class}
\name{SSModelDynamicGompertz-class}
\alias{SSModelDynamicGompertz-class}
\alias{SSModelDynamicGompertz}
\title{Class for dynamic Gompertz curve state space model object.}
\description{
Class for dynamic Gompertz curve state space model object.

\subsection{Methods}{
\code{get_model(y, q = NULL, sea.type = 'trigonometric', sea.period = 7)}
Retrieves the model object.
\subsection{Parameters}{\itemize{
\item{\code{y} The cumulated variable.}
\item{\code{q} The signal-to-noise ratio (ratio of slope to irregular
variance). Defaults to \code{'NULL'}, in which case no signal-to-noise ratio
will be imposed. Instead, it will be estimated.}
\item{\code{sea.type} Seasonal type. Options are \code{'trigonometric'} and
\code{'none'}. \code{'trigonometric'} will yield a model with a trigonometric
seasonal component and \code{'none'} will yield a model with no seasonal
component.}
\item{\code{sea.period}  The period of seasonality. For a day-of-the-week
effect with daily data, this would be 7. Not required if
\code{sea.type = 'none'}.}
}}
\subsection{Return Value}{\code{KFS} model object.}
}
}

\examples{
library(tsgc)
data(gauteng,package="tsgc")
idx.est <- zoo::index(gauteng) <= as.Date("2020-07-06")

# Specify a model
model <- SSModelDynamicGompertz$new(Y = gauteng[idx.est], q = 0.005)
# Estimate a specified model
res <- model$estimate()

}
