% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{residuals.tsissm.estimate}
\alias{residuals.tsissm.estimate}
\alias{residuals}
\title{Model Residuals}
\usage{
\method{residuals}{tsissm.estimate}(object, standardize = FALSE, transformed = TRUE, ...)
}
\arguments{
\item{object}{an object of class \dQuote{tsissm.estimate}.}

\item{standardize}{whether to scale the residuals by the estimated standard deviation.}

\item{transformed}{residuals based values in transformed space (Box Cox).}

\item{...}{not currently used.}
}
\value{
An xts vector of the model residuals for h = 1, else a data.table
with rows representing the first prediction date and columns the h-ahead
forecast residuals.
}
\description{
Extract the residual values from an estimated model.
}
\details{
For h>1, this is like performing an in-sample backtest starting at
time 1 with fixed coefficients. The purpose of having the matrix of h-step
ahead residuals is in order to calculate the 1:h covariance matrix as well
as the cross 1:h covariance matrix when ensembling series at multiple horizons.
}
\note{
The function can use parallel functionality (for h>1) as long as the
user has set up a \code{\link[future]{plan}} using the future package.
}
