% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extra.R
\name{combn_fast}
\alias{combn_fast}
\title{Fast combination of n elements, taken m at a time}
\usage{
combn_fast(x, m)
}
\arguments{
\item{x}{integer vector source for combinations}

\item{m}{number of elements to choose.}
}
\value{
a matrix with m rows.
}
\description{
Fast combination of n elements, taken m at a time
}
\details{
This is a significantly faster version of \code{\link[utils]{combn}}. For
an integer vector x of length 1000 and m of 3 which results in a matrix of size
3 x 166,167,000, the speed improvement is about 9 times (11 secs vs 99 secs).
This code is written using Armadillo C++ and 64 bit unsingned integers.
}
\examples{
all.equal(combn(1:10, 3), combn_fast(1:10,3))
}
