% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{simulate.cgarch.estimate}
\alias{simulate.cgarch.estimate}
\alias{simulate}
\alias{simulate.dcc.estimate}
\alias{simulate.gogarch.estimate}
\title{Model Simulation}
\usage{
\method{simulate}{cgarch.estimate}(
  object,
  nsim = 1,
  seed = NULL,
  h = 100,
  burn = 0,
  Q_init = NULL,
  Z_init = NULL,
  init_method = c("start", "end"),
  cond_mean = NULL,
  sim_method = c("parametric", "bootstrap"),
  ...
)

\method{simulate}{dcc.estimate}(
  object,
  nsim = 1,
  seed = NULL,
  h = 100,
  burn = 0,
  Q_init = NULL,
  Z_init = NULL,
  init_method = c("start", "end"),
  cond_mean = NULL,
  sim_method = c("parametric", "bootstrap"),
  ...
)

\method{simulate}{gogarch.estimate}(
  object,
  nsim = 1,
  seed = NULL,
  h = 100,
  burn = 0,
  cond_mean = NULL,
  sim_method = c("parametric", "bootstrap"),
  ...
)
}
\arguments{
\item{object}{an estimated object from one of the models in the package.}

\item{nsim}{the number of sample paths to generate.}

\item{seed}{an integer that will be used in a call to set.seed before simulating.}

\item{h}{the number of time steps to simulate paths for.}

\item{burn}{burn in. Will be discarded before returning the output.}

\item{Q_init}{an optional array of matrices of dimension
n_series x n_series x maxpq for initializing the DCC model (not relevant in
the constant correlation case), where maxpq is the maximum DCC model order.}

\item{Z_init}{an optional matrix of size maxpq x m of initialization values for the
standardized innovations of the DCC model. For this copula model, care should be
taken as these represent the DCC copula standardized innovations, not the
univariate GARCH innovations.}

\item{init_method}{method to initialize the DCC and GARCH recursion (unless
\dQuote{Q_init} and \dQuote{Z_init} are not NULL in which case those take
priority for those inputs). The \dQuote{start} method initializes the recursion
with the same values used during estimation, whereas the \dQuote{end} method
uses the last values of the estimated model to initialize the recursion. In
the constant correlation case, only the the GARCH initialization is relevant.}

\item{cond_mean}{an optional matrix (h x n_series) of the simulated conditional
mean for the series which is used to recenter the simulated distribution.}

\item{sim_method}{white noise method for generating random sample for the
multivariate distribution. The default \dQuote{parametric} samples random
variates from the underlying error distribution whilst the \dQuote{bootstrap}
samples from the whitened innovations of the fitted model.}

\item{...}{no additional arguments currently supported.}
}
\value{
A simulation class object for which methods exists for extracting
relevant statistics such as the correlation, covariance, etc.
}
\description{
Simulates paths of a model.
}
\details{
Part of the code makes use of parallel functionality via
the \dQuote{future} package (see \code{\link[future]{plan}}). The dimension
the parallel execution operates on is the number of series (for the
individual GARCH series simulation), so unless you have more than 100 series
then it is possible that using a parallel back-end may actually result in
slower execution due to the overhead involved.
}
