% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{tscoskew.gogarch.estimate}
\alias{tscoskew.gogarch.estimate}
\alias{tscoskew}
\alias{tscoskew.gogarch.predict}
\alias{tscoskew.gogarch.simulate}
\title{Coskewness Extractor}
\usage{
\method{tscoskew}{gogarch.estimate}(
  object,
  index = NULL,
  distribution = FALSE,
  standardize = TRUE,
  folded = TRUE,
  ...
)

\method{tscoskew}{gogarch.predict}(
  object,
  index = NULL,
  distribution = FALSE,
  standardize = TRUE,
  folded = TRUE,
  ...
)

\method{tscoskew}{gogarch.simulate}(
  object,
  index = NULL,
  distribution = FALSE,
  standardize = TRUE,
  folded = TRUE,
  ...
)
}
\arguments{
\item{object}{an object class from one of the models in the package.}

\item{index}{the time index (integer) from which to extract a subset of the
coskewness array rather than the whole time series.}

\item{distribution}{whether to return the full simulated coskewness distribution
for the predicted and simulated objects.}

\item{standardize}{whether to standardize the 3th co-moment so that it represents
the coskewness.}

\item{folded}{whether to return the result as a folded or unfolded array. The folded
array is n_series x n_series x n_series x horizon (x simulation if predicted or simulated
object). The unfolded array is a n_series x (n_series^2) x horizon array. Calculations
such as weighted co-moments are based on the unfolded array using the Kronecker operator.}

\item{...}{none}
}
\value{
the coskewness (see details).
}
\description{
Extracts the conditional coskewness matrices.
}
\details{
The calculation of the coskewness array from the independent factors is very
expensive in terms of memory footprint as well as computation time.
While it does take advantage of multiple threads if required (see
\code{\link[RcppParallel]{setThreadOptions}}), in the case of many series this
will quickly become difficult for systems low RAM. Because of this, there is
the option to extract a specific point in time output using the \code{index} argument.
}
\author{
Alexios Galanos
}
