% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mstomp-par.R, R/mstomp.R
\name{mstomp_par}
\alias{mstomp_par}
\alias{mstomp}
\title{Multivariate STOMP algorithm Parallel version}
\usage{
mstomp_par(
  data,
  window_size,
  exclusion_zone = getOption("tsmp.exclusion_zone", 1/2),
  verbose = getOption("tsmp.verbose", 2),
  must_dim = NULL,
  exc_dim = NULL,
  n_workers = 2
)

mstomp(
  data,
  window_size,
  exclusion_zone = getOption("tsmp.exclusion_zone", 1/2),
  verbose = getOption("tsmp.verbose", 2),
  must_dim = NULL,
  exc_dim = NULL
)
}
\arguments{
\item{data}{a \code{matrix} of \code{numeric}, where each column is a time series. Accepts \code{vector} (see
details), \code{list} and \code{data.frame} too.}

\item{window_size}{an \code{int} with the size of the sliding window.}

\item{exclusion_zone}{a \code{numeric}. Size of the exclusion zone, based on window size (default is
\code{1/2}).}

\item{verbose}{an \code{int}. See details. (Default is \code{2}).}

\item{must_dim}{an \code{int} or \code{vector} of which dimensions to forcibly include (default is \code{NULL}).}

\item{exc_dim}{an \code{int} or \code{vector} of which dimensions to exclude (default is \code{NULL}).}

\item{n_workers}{an \code{int}. Number of workers for parallel. (Default is \code{2}).}
}
\value{
Returns a \code{MultiMatrixProfile} object, a \code{list} with the matrix profile \code{mp}, profile index \code{pi}
left and right matrix profile \code{lmp}, \code{rmp} and profile index \code{lpi}, \code{rpi}, window size \code{w},
number of dimensions \code{n_dim}, exclusion zone \code{ez}, must dimensions \code{must} and excluded dimensions \code{exc}.

If the input has only one dimension, returns the same as \code{\link[=stomp]{stomp()}}.
}
\description{
Computes the Matrix Profile and Profile Index for Multivariate Time Series.
}
\details{
The Matrix Profile, has the potential to revolutionize time series data mining because of its
generality, versatility, simplicity and scalability. In particular it has implications for time
series motif discovery, time series joins, shapelet discovery (classification), density
estimation, semantic segmentation, visualization, rule discovery, clustering etc. The MSTOMP
computes the Matrix Profile and Profile Index for Multivariate Time Series that is meaningful for
multidimensional MOTIF discovery. It uses the STOMP algorithm that is faster than STAMP but lacks
its anytime property.

Although this functions handles Multivariate Time Series, it can also be used to handle
Univariate Time Series. \code{verbose} changes how much information is printed by this function; \code{0}
means nothing, \code{1} means text, \code{2} adds the progress bar, \code{3} adds the finish sound.
}
\section{Functions}{
\itemize{
\item \code{mstomp_par()}: Parallel version.

\item \code{mstomp()}: Single thread version.

}}
\examples{
# using all dimensions
mp <- mstomp(mp_toy_data$data[1:150, ], 30, verbose = 0)
\donttest{
#' # using threads
mp <- mstomp_par(mp_toy_data$data[1:150, ], 30, verbose = 0)

# force using dimensions 1 and 2
mp <- mstomp(mp_toy_data$data[1:200, ], 30, must_dim = c(1, 2))
# exclude dimensions 2 and 3
mp2 <- mstomp(mp_toy_data$data[1:200, ], 30, exc_dim = c(2, 3))
}

}
\references{
\itemize{
\item Yeh CM, Kavantzas N, Keogh E. Matrix Profile VI : Meaningful Multidimensional Motif
Discovery.
}

\itemize{
\item Zhu Y, Imamura M, Nikovski D, Keogh E. Matrix Profile VII: Time Series Chains: A
New Primitive for Time Series Data Mining. Knowl Inf Syst. 2018 Jun 2;1-27.
}

Website: \url{https://sites.google.com/view/mstamp/}

Website: \url{http://www.cs.ucr.edu/~eamonn/MatrixProfile.html}
}
\seealso{
Other matrix profile computations: 
\code{\link{scrimp}()},
\code{\link{stamp_par}()},
\code{\link{stomp_par}()},
\code{\link{tsmp}()},
\code{\link{valmod}()}
}
\concept{matrix profile computations}
