% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.tsnet_fit}
\alias{print.tsnet_fit}
\title{Print method for tsnet_fit objects}
\usage{
\method{print}{tsnet_fit}(x, ...)
}
\arguments{
\item{x}{A tsnet_fit object.}

\item{...}{Additional arguments passed to the print method (currently not used).}
}
\value{
Prints a summary to the console.
}
\description{
This method provides a summary of the Bayesian GVAR model fitted with \code{\link{stan_gvar}}.
It prints general information about the model, including the estimation method and the number of chains and iterations
It also prints the posterior mean of the temporal and contemporaneous coefficients.
}
\examples{
\donttest{
# Load example data
data(ts_data)
example_data <- ts_data[1:100,1:3]

# Fit the model
fit <- stan_gvar(example_data,
                 method = "sampling",
                 cov_prior = "IW",
                 n_chains = 2)

print(fit)
}
}
