% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_aug_stretch.R
\name{ts_aug_stretch}
\alias{ts_aug_stretch}
\title{Augmentation by Stretch}
\usage{
ts_aug_stretch(scale_factor = 1.2)
}
\arguments{
\item{scale_factor}{Numeric factor used to scale deviations.}
}
\value{
A \code{ts_aug_stretch} object.
}
\description{
Increase within-window deviation magnitude by a scaling factor
to produce higher-variance variants.
}
\examples{
# Stretch augmentation increases within-window deviations
# Load package and example dataset
library(daltoolbox)
data(tsd)

# Convert to sliding windows and preview
xw <- ts_data(tsd$y, 10)
ts_head(xw)

# Apply stretch augmentation and inspect augmented windows
augment <- ts_aug_stretch()
augment <- fit(augment, xw)
xa <- transform(augment, xw)
ts_head(xa)
}
\references{
\itemize{
\item Q. Wen et al. (2021). Time Series Data Augmentation for Deep Learning:
A Survey. IJCAI Workshop on Time Series.
}
}
