% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/riskpredict.R
\name{riskpredict}
\alias{riskpredict}
\title{Risk prediction at specific time points}
\usage{
riskpredict(fit, timeset = NULL, nboot = 0, seed = 0)
}
\arguments{
\item{fit}{A fitted object returned by the function \code{surv.tteICE} or \code{scr.tteICE}.}

\item{timeset}{Time at which to predict the risk. If \code{timeset=NULL}, risks will be predict at the
quartiles of the maximum follow-up time.}

\item{nboot}{Number of resampling in bootstrapping. By default, \code{nboot = 0}, meaning no bootstrap is performed and the standard error is computed using the explicit analytical formula.}

\item{seed}{Sets the random seed used when generating bootstrap samples.}
}
\value{
A matrix. The meanings of each row are: time points, potential cumulative incidences (under
treated and under control), treatment effects, standard errors, and P-values.
}
\description{
This function predicts the potential cumulative incidence function and treatment effect at
specific time points.
}
\examples{
## load data
data(bmt)
bmt = transform(bmt, d4=d2+d3)
A = as.numeric(bmt$group>1)
X = as.matrix(bmt[,c('z1','z3','z5')])
## Composite variable strategy,
## nonparametric estimation without covariates
fit1 = scr.tteICE(A, bmt$t1, bmt$d1, bmt$t2, bmt$d2, "composite")
riskpredict(fit1, timeset=c(670,2000))

}
\seealso{
\code{\link[tteICE]{scr.tteICE}}, \code{\link[tteICE]{surv.tteICE}}, \code{\link[tteICE]{surv.boot}}
}
