% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twoStageTMLEMSM.R
\name{twoStageTMLEmsm}
\alias{twoStageTMLEmsm}
\title{twoStageTMLEmsm}
\usage{
twoStageTMLEmsm(
  Y,
  A,
  W,
  V,
  Delta.W,
  W.stage2,
  Delta = rep(1, length(Y)),
  pi = NULL,
  piform = NULL,
  pi.SL.library = c("SL.glm", "SL.gam", "SL.glmnet", "tmle.SL.dbarts.k.5"),
  V.pi = 10,
  pi.discreteSL = TRUE,
  condSetNames = c("A", "V", "W", "Y"),
  id = NULL,
  Q.family = "gaussian",
  augmentW = TRUE,
  augW.SL.library = c("SL.glm", "SL.glmnet", "tmle.SL.dbarts2"),
  rareOutcome = FALSE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{Y}{outcome of interest (missingness allowed)}

\item{A}{binary treatment indicator}

\item{W}{matrix or data.frame of covariates measured on entire population}

\item{V}{vector, matrix, or dataframe of covariates used to define MSM strata}

\item{Delta.W}{Indicator of inclusion in subset with additional information}

\item{W.stage2}{matrix or data.frame of covariates measured in subset population}

\item{Delta}{binary indicator that outcome Y is observed}

\item{pi}{optional vector of sampling probabilities}

\item{piform}{parametric regression formula for estimating \code{pi} (see Details)}

\item{pi.SL.library}{super learner library for estimating \code{pi} (see Details)}

\item{V.pi}{optional number of cross-validation folds for super learning
(ignored when piform or pi is provided)}

\item{pi.discreteSL}{flag to indicate whether to use ensemble or discrete
super learning (ignored when piform or pi is provided)}

\item{condSetNames}{Variables to include as predictors of missingness
in \code{W.stage2}, any combination of \code{Y, A}, and either \code{W}
(for all covariates in \code{W}), or individual covariate names in \code{W}}

\item{id}{optional indicator of independent units of observation}

\item{Q.family}{outcome regression family, "gaussian" or "binomial"}

\item{augmentW}{set to \code{TRUE} to augment \code{W} with predicted outcome
values when \code{A = 0} and \code{A = 1}}

\item{augW.SL.library}{super learner library for preliminary outcome
regression model (ignored when \code{augmentW} is \code{FALSE})}

\item{rareOutcome}{when \code{TRUE} sets \code{V.Q = 20, Q.discreteSL = TRUE},
\code{Q.SL.library} includes glm, glmnet, bart}

\item{verbose}{when \code{TRUE} prints informative messages}

\item{...}{other arguments passed to the \code{tmleMSM} function}
}
\value{
\describe{
Object of class "twoStageTMLE"
\item{tmle}{Treatment effect estimates and summary information from
call to \code{tmleMSM} function}
\item{twoStage}{IPCW weight estimation summary,
\code{pi} are the probabilities,\code{coef} are SL weights or coefficients
from glm fit, \code{type} of estimation procedure,
\code{discreteSL} flag indicating whether discrete super learning was used}
\item{augW}{Matrix of predicted outcomes based on stage 1 covariates only}
}
}
\description{
Inverse probability of censoring weighted TMLE for evaluating MSM
parameters when the full set of covariates is available on only
a subset of observations, as in a 2-stage design.
}
\details{
When using \code{piform} to specify a parametric model for pi that conditions
on the outcome use \code{Delta.W} as the dependent variable and \code{Y.orig}
on the right hand side of the formula instead of \code{Y}. When writing a
user-defined SL wrapper for inclusion in \code{pi.SL.library} use \code{Y}
on the left hand side of the formula. If specific covariate names are
used on the right hand side use \code{Y.orig} to condition
on the outcome.
}
\examples{
n <- 1000
set.seed(10)
W1 <- rnorm(n)
W2 <- rnorm(n)
W3 <- rnorm(n)
A <- rbinom(n, 1, plogis(-1 + .2*W1 + .3*W2 + .1*W3))
Y <- 10 + A + W1 + W2 + A*W1 + W3 + rnorm(n)
Y.bin <- rbinom(n, 1, plogis(-4.6 - 1.8* A + W1 + W2 -.3 *A*W1 + W3))
# Set 400 obs with data on W3, more likely if W1 > 1
n.sample <- 400
p.sample <- 0.5 + .2*(W1 > 1)
rows.sample <- sample(1:n, size = n.sample, p = p.sample)
Delta.W <- rep(0,n)
Delta.W[rows.sample] <- 1
W3.stage2 <- cbind(W3 = W3[Delta.W==1])

# 1. specify parametric models, misspecified outcome model (not recommended)
result1.MSM <- twoStageTMLEmsm(Y=Y, A=A, V= cbind(W1), W=cbind(W2), 
Delta.W = Delta.W, W.stage2 = W3.stage2, augmentW = FALSE,
piform = "Delta.W~ I(W1 > 0)", MSM = "A*W1", augW.SL.library = "SL.glm",
Qform = "Y~A+W1",gform="A~W1 + W2 +W3", hAVform = "A~1", verbose=TRUE)
summary(result1.MSM)

# 2. Call again, passing in previously estimated observation weights, 
# note that specifying a correct model for Q improves efficiency
result2.MSM <- twoStageTMLEmsm(Y=Y, A=A, V= cbind(W1), W=cbind(W2), 
Delta.W = Delta.W, W.stage2 = W3.stage2, augmentW = FALSE,
pi = result1.MSM$twoStage$pi, MSM = "A*W1",
Qform = "Y~ A + W1 + W2 + A*W1 + W3",gform="A~W1 + W2 +W3", hAVform = "A~1")
cbind(SE.Qmis = result1.MSM$tmle$se, SE.Qcor = result2.MSM$tmle$se)

\donttest{
#Binary outcome, augmentW, rareOutcome
result3.MSM <- twoStageTMLEmsm(Y=Y.bin, A=A, V= cbind(W1), W=cbind(W2), 
Delta.W = Delta.W, W.stage2 = W3.stage2, augmentW = TRUE,
piform = "Delta.W~ I(W1 > 0)", MSM = "A*W1", gform="A~W1 + W2 +W3",
 Q.family = "binomial", rareOutcome=TRUE)
}

}
\seealso{
\itemize{
\item \code{\link[tmle:tmleMSM]{tmle::tmleMSM()}} for details on customizing the estimation procedure
\item \code{\link[=twoStageTMLE]{twoStageTMLE()}} for estimating marginal effects
}
}
