% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/numericalDifferentiation.R
\name{get_varying_h}
\alias{get_varying_h}
\title{Get differences 'h' which are adjusted for overly large degrees of freedom parameters}
\usage{
get_varying_h(p, M, params, model)
}
\arguments{
\item{p}{a positive integer specifying the autoregressive order of the model.}

\item{M}{\describe{
  \item{For \strong{GMAR} and \strong{StMAR} models:}{a positive integer specifying the number of mixture components.}
  \item{For \strong{G-StMAR} models:}{a size \eqn{(2\times 1)} integer vector specifying the number of \emph{GMAR type} components \code{M1} in the
   first element and \emph{StMAR type} components \code{M2} in the second element. The total number of mixture components is \code{M=M1+M2}.}
}}

\item{params}{a real valued parameter vector specifying the model.
 \describe{
   \item{For \strong{non-restricted} models:}{
     Size \eqn{(M(p+3)+M-M1-1\times 1)} vector \strong{\eqn{\theta}}\eqn{=}(\strong{\eqn{\upsilon_{1}}}\eqn{,...,}\strong{\eqn{\upsilon_{M}}},
     \eqn{\alpha_{1},...,\alpha_{M-1},}\strong{\eqn{\nu}}) where
     \itemize{
       \item \strong{\eqn{\upsilon_{m}}}\eqn{=(\phi_{m,0},}\strong{\eqn{\phi_{m}}}\eqn{,}\eqn{\sigma_{m}^2)}
       \item \strong{\eqn{\phi_{m}}}\eqn{=(\phi_{m,1},...,\phi_{m,p}), m=1,...,M}
       \item \strong{\eqn{\nu}}\eqn{=(\nu_{M1+1},...,\nu_{M})}
       \item \eqn{M1} is the number of GMAR type regimes.
     }
     In the \strong{GMAR} model, \eqn{M1=M} and the parameter \strong{\eqn{\nu}} dropped. In the \strong{StMAR} model, \eqn{M1=0}.

     If the model imposes \strong{linear constraints} on the autoregressive parameters:
     Replace the vectors \strong{\eqn{\phi_{m}}} with the vectors \strong{\eqn{\psi_{m}}} that satisfy
      \strong{\eqn{\phi_{m}}}\eqn{=}\strong{\eqn{C_{m}\psi_{m}}} (see the argument \code{constraints}).
     }
   \item{For \strong{restricted} models:}{
     Size \eqn{(3M+M-M1+p-1\times 1)} vector \strong{\eqn{\theta}}\eqn{=(\phi_{1,0},...,\phi_{M,0},}\strong{\eqn{\phi}}\eqn{,}
     \eqn{\sigma_{1}^2,...,\sigma_{M}^2,}\eqn{\alpha_{1},...,\alpha_{M-1},}\strong{\eqn{\nu}}), where \strong{\eqn{\phi}}=\eqn{(\phi_{1},...,\phi_{p})}
     contains the AR coefficients, which are common for all regimes.

     If the model imposes \strong{linear constraints} on the autoregressive parameters:
     Replace the vector \strong{\eqn{\phi}} with the vector \strong{\eqn{\psi}} that satisfies
      \strong{\eqn{\phi}}\eqn{=}\strong{\eqn{C\psi}} (see the argument \code{constraints}).
   }
 }
 Symbol \eqn{\phi} denotes an AR coefficient, \eqn{\sigma^2} a variance, \eqn{\alpha} a mixing weight, and \eqn{\nu} a degrees of
 freedom parameter. If \code{parametrization=="mean"}, just replace each intercept term \eqn{\phi_{m,0}} with the regimewise mean
 \eqn{\mu_m = \phi_{m,0}/(1-\sum\phi_{i,m})}. In the \strong{G-StMAR} model, the first \code{M1} components are \emph{GMAR type}
 and the rest \code{M2} components are \emph{StMAR type}.
 Note that in the case \strong{M=1}, the mixing weight parameters \eqn{\alpha} are dropped, and in the case of \strong{StMAR} or \strong{G-StMAR} model,
 the degrees of freedom parameters \eqn{\nu} have to be larger than \eqn{2}.}

\item{model}{is "GMAR", "StMAR", or "G-StMAR" model considered? In the G-StMAR model, the first \code{M1} components
are \emph{GMAR type} and the rest \code{M2} components are \emph{StMAR type}.}
}
\value{
Returns a vector with the same length as \code{params}. For other parameters than degrees
  of freedom parameters larger than 100, the differences will be \code{6e-6}. For the large degrees of
  freedom parameters, the difference will be \code{signif(df/1000, digits=2)}.
}
\description{
\code{get_varying_h} adjusts differences for overly large degrees of freedom parameters
  for finite difference approximation of the derivatives of the log-likelihood function. StMAR and
  G-StMAR models are supported.
}
\details{
This function is used for approximating gradient and Hessian of a StMAR or G-StMAR model. Large
  degrees of freedom parameters cause significant numerical error if too small differences are used.
}
\keyword{internal}
