% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Galway.R
\docType{data}
\name{galway_2}
\alias{galway_2}
\title{Secondary colors of the University of Galway, Ireland}
\format{
An object of class \code{character} of length 14.
}
\source{
Colour definitions are based on \href{https://www.universityofgalway.ie}{UGalway}'s 
\href{https://www.universityofgalway.ie/media/brand/11901_University_of_Galway_Brand_Guidelines_v13.pdf}{brand guidelines} (PDF).
}
\usage{
galway_2
}
\value{
A names vector of colors (HEX/HTML codes of type character).
}
\description{
\code{galway_2} provides the 14 secondary colors
of the \href{https://www.universityofgalway.ie}{University of Galway}, Ireland.
}
\details{
The 14 secondary colors are
\code{"aqua marine"} (defined as HEX #00b1ba),
\code{"ocean blue"} (defined as HEX #0080a3),
\code{"spring green"} (defined as HEX #00bf6f),
\code{"lime green"} (defined as HEX #c5e86c), 
\code{"orange"} (defined as HEX #f58e2f), 
\code{"rose"} (defined as HEX #e30044), 
\code{"yellow"} (defined as HEX #ffc72b), 
\code{"deep orchid"} (defined as HEX #c4299b), 
\code{"lavender pink"} (defined as HEX #e66eb2), 
\code{"violet"} (defined as HEX #753abd), 
\code{"ash"} (defined as HEX #5e514d), 
\code{"warm stone"} (defined as HEX #94795d), 
\code{"sandstone"} (defined as HEX #c4c0b7), and 
\code{"black"} (defined as HEX #000000). 

\code{galway_2} uses the HEX color definitions.
}
\examples{
galway_2
unikn::seecol(galway_2, main = "Secondary colours of the University of Galway") # view palette

}
\seealso{
\code{\link{galway_1}} for primary colors of the University of Galway; 
\code{\link[unikn]{seecol}} for viewing and comparing color palettes;
\code{\link[unikn]{usecol}} for using color palettes;
\code{\link[unikn]{simcol}} for finding similar colors;
\code{\link[unikn]{newpal}} for defining new color palettes;
\code{\link[unikn]{grepal}} for finding named colors.

Other Irish university color palettes: 
\code{\link{galway_1}},
\code{\link{limerick_1}},
\code{\link{limerick_2}},
\code{\link{maynooth}},
\code{\link{trinity_1}},
\code{\link{trinity_2}},
\code{\link{ucc_1}},
\code{\link{ucc_2}},
\code{\link{ucd}}
}
\author{
\strong{unicol}, 2320-07-16.
}
\concept{Irish university color palettes}
\keyword{datasets}
